#!/usr/bin/env python
# -*- coding: utf-8 -*-

# ---------------------------------------------------------------------------
# mod14-gen-query.py
#     MODIS  WIST
# Author: Maxim Dubinin (sim@gis-lab.info)
# Date created: 06.08.2010
# Last updated: 06.08.2010
# ---------------------------------------------------------------------------

import sys
import os
import calendar

def usage():
    '''Show usage synopsis.
    '''
    print 'Usage: mod14-gen-query.py'
    '''Example python modfires-down-list.py MOLT/MOD14A1.005 19 21 3 4 mod14a1.txt
    '''
    sys.exit( 1 )

def makequery(d1,d2):
    str = 'GROUP                = INVENTORY_SEARCH' + '\n' +\
        'MESSAGE_ID           = "0"'  + '\n' +\
        'DATASET_ID           = ("MODIS/Terra Thermal Anomalies/Fire 5-Min L2 Swath 1km V005")'  + '\n' +\
        'GROUP                = RANGE_LOC'  + '\n' +\
        'NORTH_LATITUDE       = 84.6667'  + '\n' +\
        'SOUTH_LATITUDE       = 40.6667'  + '\n' +\
        'WEST_LONGITUDE       = 20.0000'  + '\n' +\
        'EAST_LONGITUDE       = 180.0000' + '\n' +\
        'END_GROUP            = RANGE_LOC' + '\n' +\
        'START_DATE           = ' + d1 + 'T00:00:00Z' + '\n' +\
        'STOP_DATE            = ' + d2 + 'T23:59:59Z' + '\n' +\
        'GRANULE_LIMIT        = 2000' + '\n' +\
        'GUIDE_LIMIT          = 40' + '\n' +\
        'TIME_LIMIT           = 90' + '\n' +\
        'WG_MISSIONS          = ("terra_modis_land")' + '\n' +\
        'WG_SRCHTYPE          = "INVENTORY_SEARCH"' + '\n' +\
        'WG_OPTSTYPE          = "All Options"' + '\n' +\
        'WG_GEOTYPE           = "Equatorial JS"' + '\n' +\
        'WG_TIMETYPE          = "Standard Date Range"' + '\n' +\
        'WG_DEPVALIDTYPE      = "Discipline"' + '\n' +\
        'END_GROUP            = INVENTORY_SEARCH' + '\n' +\
        'END '
    return str

if __name__ == '__main__':

    #args = sys.argv[ 1: ]
    #if args is None or len( args ) < 0:
    #    usage()
    
    #type = args[ 0 ]
    startyear = 2000
    endyear = 2012
    
    for year in range(startyear,endyear):
        for month in range(1,13):
            firstday = str(year) + "-" + str(month) + "-01"
            middleday1 = str(year) + "-" + str(month) + "-15"
            middleday2 = str(year) + "-" + str(month) + "-16"
            lastday = str(year) + "-" + str(month) + "-" + str(calendar.monthrange(year,month)[1])
            
            output = str(year) + "_" + str(month).zfill(2) + "_1.query"
            
            res=open(output,'w')
            res.writelines(makequery(firstday,middleday1))
            res.close()
            
            output = str(year) + "_" + str(month).zfill(2) + "_2.query"
            res=open(output,'w')
            res.writelines(makequery(middleday2,lastday))
            res.close()
    