#-*- encoding: utf-8 -*-
#python table.py >table

import csv
import os

f = "list.csv"
reader = csv.reader( open( f, "rb") )

print """== ==
{| class="wikitable sortable" border="1" width="100%"
! | 
! |  
! | 
! | 
! | 
! |  
! | 
! |  
! | 
! | \n"""

first = True
for row in reader:
    if first:
        first = False
        continue
    cat,code,descr,format,url,update,geo,date = row
    descr = descr
    datalink = "[http://gis-lab.info/data/mos.ru/" + code + ".7z  csv]"
    url = "[" + url + " ]<br>" + datalink
    datalink_norm = "[http://gis-lab.info/data/mos.ru/" + code + "_norm.7z csv_norm]"
    datalink_shp = "[http://gis-lab.info/data/mos.ru/" + code + "_shp.7z shp]"
    datalink_osm = "[http://gis-lab.info/data/mos.ru/" + code + "_osm.7z osm]"
    
    #don't gen shp link for non-geo files
    if geo == "":
        datalink_shp = ""
        datalink_osm = ""
        
    #count number of objects
    datafile = open("data/"+code+".csv","rb")
    numobj = len(datafile.readlines()) - 1
    datafile.close()
    
    #change compared to prev version
    if os.path.isfile("data-prev/"+code+".csv"):
        datafileprev = open("data-prev/"+code+".csv","rb")
        numobjprev = len(datafileprev.readlines()) - 1
        datafileprev.close()
    else:
        numobjprev = numobj

    numobjchange = numobj - numobjprev
    
    print """|-
| %s
| %s
| %s
| %s
| %s
| %s
| %s
| %s
| %s
| %s<br>%s<br>%s""" % (code,descr.decode('utf-8').encode('cp1251'),cat.decode('utf-8').encode('cp1251'),numobj, numobjchange,date,geo.decode('utf-8').encode('cp1251'),update.decode('utf-8').encode('cp1251'),url,datalink_norm,datalink_shp,datalink_osm)

print """|}"""
