#-*- encoding: utf-8 -*-

import glob
import shutil
import os

def csv2utf(f,fr):
    #convert csv to utf8
    cmd = "c:\\tools\\echo1.exe -ne  \"\xEF\xBB\xBF\" > " + fr + "_utf.csv"
    os.system(cmd)
    cmd = "iconv -f WINDOWS-1251 -t UTF-8 " + f + ">>" + fr + "_utf.csv"
    os.system(cmd)
    os.remove(f)
    shutil.move(fr + "_utf.csv",f)

def make_csvt(f,fr):
    fcsv = open(f,"r")
    ss = fcsv.readlines()[0]
    fcsv.close()
    
    fields = ss.split(";")
    ss = ""
    for field in fields:
        ss = ss + "\"String(255)\","
    
    fcsvtname = fr + ".csvt"
    fcsvt = open(fcsvtname,"w")
    fcsvt.write(ss[:-1])
    fcsvt.close()

def copy_prj(f,fr):
    fprjname = fr + ".prj"
    shutil.copyfile("../prj.prj",fprjname)

def csv_7z(f,fr):
    csv_7zname = fr + "_norm.7z"
    cmd = "C:/tools/7-Zip/7z.exe a -t7z -m0=lzma -mx=9 -mfb=64 -md=32m -ms=on " + csv_7zname + " " + fr + "*"
    os.system(cmd)

def make_vrt(f,fr):
    fvrtname = fr + ".vrt"
    flyrname = fr
    
    vrt = """<OGRVRTDataSource>
    <OGRVRTLayer name="%s">
        <SrcDataSource relativeToVRT="1">%s</SrcDataSource>
        <LayerSRS>EPSG:3857</LayerSRS>
        <GeometryType>wkbUnknown</GeometryType>
        <GeometryField encoding="WKT" field="WKT"/>
    </OGRVRTLayer>
</OGRVRTDataSource>""" % (flyrname,f)
    
    fcsvt = open(fvrtname,"w")
    fcsvt.write(vrt)
    fcsvt.close()

def make_shp(f,fr):
    fcsv = open(f,"r")
    ss = fcsv.readlines()[0]
    fcsv.close()
    
    if "WKT" in ss:
        flyrname = fr
        fshpname = fr + ".shp"
        cmd = "ogr2ogr -lco ENCODING=UTF-8 -s_srs \"EPSG:3857\" -t_srs \"EPSG:4326\" " + fshpname + " " + f
        print(cmd)
        os.system(cmd)
        
        shp_7zname = f.replace(".csv","_shp.7z")
        cmd = "C:/tools/7-Zip/7z.exe a -t7z -m0=lzma -mx=9 -mfb=64 -md=32m -ms=on " + shp_7zname + " " + flyrname+".shp " + flyrname+".shx " + flyrname+".dbf " + flyrname+".prj " + flyrname+".cpg" 
        os.system(cmd)

def make_osm(f,fr):
    fcsv = open(f,"r")
    ss = fcsv.readlines()[0]
    fcsv.close()
    
    if "WKT" in ss:
        cmd = "python c:\gis\osm2shp\ogr2osm.py " + fr + ".vrt"
        os.system(cmd)

def osm_7z(f,fr):
    osm_7zname = fr + "_osm.7z"
    if os.path.isfile(fr + ".osm"):
        cmd = "C:/tools/7-Zip/7z.exe a -t7z -m0=lzma -mx=9 -mfb=64 -md=32m -ms=on " + osm_7zname + " " + fr + ".osm"
        os.system(cmd)

if __name__ == '__main__':
    #working folder, todo: move to params
    os.chdir("data-norm")
    for f in glob.glob("*.csv"):
    
        fr = f.replace(".csv","")
        
        csv2utf(f,fr)        
        make_csvt(f,fr)
        copy_prj(f,fr)
        make_vrt(f,fr)
        csv_7z(f,fr)
        make_shp(f,fr)
        make_osm(f,fr)
        osm_7z(f,fr)
        for fd in glob.glob(fr + ".*"):
            os.remove(fd) 